declare module '@mx51/spi-client-js/Cashout' {
  import { Message } from '@mx51/spi-client-js/Messages';
  import { SpiConfig, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  import { TransactionData } from '@mx51/spi-client-js/types';
  interface CashoutOnlyRequestData {
      pos_ref_id: string;
      cash_amount: number;
      surcharge_amount: number;
  }
  export class CashoutOnlyRequest {
      SurchargeAmount: number;
      readonly PosRefId: string;
      readonly CashoutAmount: number;
      protected Config: SpiConfig;
      protected Options: TransactionOptions;
      constructor(amountCents: number, posRefId: string);
      ToMessage(): Message<CashoutOnlyRequestData>;
  }
  export class CashoutOnlyResponse {
      readonly RequestId: string;
      readonly PosRefId: string;
      readonly SchemeName: string;
      readonly Success: boolean;
      private readonly _m;
      constructor(m: Message<TransactionData>);
      GetRRN(): string;
      GetCashoutAmount(): any;
      GetBankNonCashAmount(): number;
      GetBankCashAmount(): any;
      GetCustomerReceipt(): string;
      GetMerchantReceipt(): string;
      GetResponseText(): string;
      GetResponseCode(): string;
      GetTerminalReferenceId(): any;
      GetAccountType(): any;
      GetAuthCode(): any;
      GetBankDate(): string;
      GetBankTime(): string;
      GetMaskedPan(): string;
      GetTerminalId(): string;
      WasMerchantReceiptPrinted(): boolean;
      WasCustomerReceiptPrinted(): boolean;
      GetSurchargeAmount(): any;
      GetResponseValue(attribute: string): any;
  }
  export {};

}
declare module '@mx51/spi-client-js/Connection' {
  import { Spi } from "@mx51/spi-client-js/Spi";
  export const ConnectionState: {
      Disconnected: string;
      Connecting: string;
      Connected: string;
  };
  export const MXA_VERSION = 290;
  export const SPI_PROTOCOL: string;
  export class ConnectionStateEventArgs {
      ConnectionState: string;
      constructor(connectionState: string);
  }
  export class MessageEventArgs {
      Message: any;
      constructor(message: any);
  }
  export class Connection {
      Address: string;
      Connected: boolean;
      SpiProtocol: string;
      State: string;
      _conectionTimeout: any;
      _connectionTimeout: any;
      _spi: any;
      _ws: any;
      constructor(spi: Spi);
      _cancelConnectionTimeout(): void;
      Connect(): void;
      Disconnect(): void;
      Send(message: any): void;
      onOpened(): void;
      onClosed(): void;
      pollWebSocketConnection(count?: number): boolean;
      onMessageReceived(message: any): void;
      onError(err: any): void;
  }

}
declare module '@mx51/spi-client-js/Crypto' {
  export class Crypto {
      static AesEncrypt(key: string, data: string): any;
      static AesDecrypt(key: string, data: string): any;
      static AesEncryptCbc(key: string, data: string): any;
      static AesEncryptGcm(key: string, data: string): string;
      static AesDecryptCbc(key: string, data: string): any;
      static AesDecryptGcm(key: string, encryptedData: string): string;
      static HmacSignature(key: string, messageToSign: string): string;
      /**
       * This utility function calculates the SHA-256 value in hexadecimal format
       * @param {String} value the value to be hashed
       */
      static GenerateHash(value: string): string;
      static hexStringToByteArray(hex: string): Uint8Array;
      static byteArrayToHexString(ba: Uint8Array): string;
      static generateRandomInt(max: number): number;
  }

}
declare module '@mx51/spi-client-js/DeviceHelper' {
  import { DeviceAddressStatus } from "@mx51/spi-client-js/Service/DeviceService";
  interface DataResponse {
      Address: string;
      ip: string;
      fqdn: string;
      last_updated: string;
  }
  interface DeviceStatusResponse {
      Data: DataResponse;
      StatusCode: number;
      StatusDescription: string;
  }
  export class DeviceHelper {
      static GenerateDeviceAddressStatus(serviceResponse: DeviceStatusResponse, currentEftposAddress: string, isSecureWebsockets: boolean): DeviceAddressStatus;
  }
  export {};

}
declare module '@mx51/spi-client-js/DiffieHellman' {
  import BN from 'bn.js';
  export class DiffieHellman {
      private _randomBigInt;
      RandomPrivateKey(maxValue: string): BN;
      PublicKey(p: string, g: number, privateKey: BN): string;
      Secret(p: string, theirPublicKey: string, yourPrivateKey: BN): string;
  }

}
declare module '@mx51/spi-client-js/KeyRollingHelper' {
  export class KeyRollingHelper {
      static PerformKeyRolling(krRequest: any, currentSecrets: any): KeyRollingResult;
  }
  export class KeyRollingResult {
      KeyRollingConfirmation: any;
      NewSecrets: any;
      constructor(keyRollingConfirmation: any, newSecrets: any);
  }

}
declare module '@mx51/spi-client-js/Logger' {
  import { StringOrNumber } from "@mx51/spi-client-js/types";
  export class Logger {
      element: HTMLElement;
      buffer: string[];
      lineSeperator: string;
      constructor(element: HTMLElement, lineSeperator?: string);
      Info(...args: Array<StringOrNumber>): void;
      Debug(...args: Array<StringOrNumber>): void;
      Warn(...args: Array<StringOrNumber>): void;
      Error(...args: Array<StringOrNumber>): void;
      Console(...args: Array<StringOrNumber>): void;
      _render(): void;
      Clear(): void;
  }

}
declare module '@mx51/spi-client-js/Messages' {
  import { Secrets } from '@mx51/spi-client-js/Secrets';
  import { Nullable } from '@mx51/spi-client-js/types';
  export const Events: Readonly<{
      PairRequest: string;
      KeyRequest: string;
      KeyResponse: string;
      KeyCheck: string;
      PairResponse: string;
      DropKeysAdvice: string;
      LoginRequest: string;
      LoginResponse: string;
      Ping: string;
      Pong: string;
      PurchaseRequest: string;
      PurchaseResponse: string;
      CancelTransactionRequest: string;
      CancelTransactionResponse: string;
      GetLastTransactionRequest: string;
      GetLastTransactionResponse: string;
      GetTransactionRequest: string;
      GetTransactionResponse: string;
      ReversalRequest: string;
      ReversalResponse: string;
      RefundRequest: string;
      RefundResponse: string;
      SignatureRequired: string;
      SignatureDeclined: string;
      SignatureAccepted: string;
      AuthCodeRequired: string;
      AuthCodeAdvice: string;
      CashoutOnlyRequest: string;
      CashoutOnlyResponse: string;
      MotoPurchaseRequest: string;
      MotoPurchaseResponse: string;
      SettleRequest: string;
      SettleResponse: string;
      SettlementEnquiryRequest: string;
      SettlementEnquiryResponse: string;
      SetPosInfoRequest: string;
      SetPosInfoResponse: string;
      KeyRollRequest: string;
      KeyRollResponse: string;
      Error: string;
      InvalidHmacSignature: string;
      PayAtTableGetTableConfig: string;
      PayAtTableSetTableConfig: string;
      PayAtTableGetBillDetails: string;
      PayAtTableBillDetails: string;
      PayAtTableBillPayment: string;
      PayAtTableGetOpenTables: string;
      PayAtTableOpenTables: string;
      PayAtTableBillPaymentFlowEnded: string;
      PayAtTableBillPaymentFlowEndedAck: string;
      PrintingRequest: string;
      PrintingResponse: string;
      TransactionUpdateMessage: string;
      TerminalStatusRequest: string;
      TerminalStatusResponse: string;
      TerminalConfigurationRequest: string;
      TerminalConfigurationResponse: string;
      BatteryLevelChanged: string;
      ZipPurchaseRequest: string;
      ZipPurchaseResponse: string;
      ZipRefundRequest: string;
      ZipRefundResponse: string;
  }>;
  export const SuccessState: Readonly<{
      Unknown: string;
      Success: string;
      Failed: string;
  }>;
  export class MessageStamp {
      PosId: string;
      Secrets: Secrets;
      ConnId: Nullable<string>;
      PosCounter: Nullable<number>;
      private _min;
      private _max;
      constructor(posId: string, secrets: Secrets);
      ResetConnection(): void;
      SetConnectionId(connId: string): void;
  }
  export class MessageEnvelope {
      readonly Message: Message<Data>;
      readonly Enc: string;
      readonly Hmac: string;
      readonly PosId: string;
      constructor(message: Message<Data>, enc: string, hmac: string, posId: string);
      toJSON(): {
          message: Message<Data>;
          enc: string;
          hmac: string;
          pos_id: string;
      };
  }
  export interface Data {
      pos_ref_id?: string;
      success?: boolean;
      error_reason?: string;
      error_detail?: string;
      msg?: string;
  }
  export class Message<T extends Partial<Data>> {
      DateTimeStamp: string;
      PosCounter: Nullable<number>;
      ConnId: string;
      IncomingHmac: string;
      DecryptedJson: string;
      PosId: string;
      readonly Id: string;
      readonly EventName: string;
      readonly Data: Nullable<T>;
      private readonly _needsEncryption;
      constructor(id: string, eventName: string, data: Nullable<T>, needsEncryption: boolean);
      GetSuccessState(): string;
      GetError(): string;
      GetErrorDetail(): string;
      static ParseBankDate(bankDate: string): Date;
      static ParseBankDateTimeStr(date: string, time: string): Date;
      static FromJson(msgJson: string, secrets: Nullable<Secrets>): Message<any>;
      ToJson(stamp: MessageStamp): any;
  }

}
declare module '@mx51/spi-client-js/Pairing' {
  import { Message } from '@mx51/spi-client-js/Messages';
  import { Secrets } from '@mx51/spi-client-js/Secrets';
  export class PairRequest {
      ToMessage(): Message<any>;
  }
  export class KeyRequest {
      RequestId: string;
      Aenc: string;
      Ahmac: string;
      constructor(m: any);
  }
  export class KeyResponse {
      RequestId: string;
      Benc: string;
      Bhmac: string;
      constructor(requestId: string, Benc: string, Bhmac: string);
      ToMessage(): Message<any>;
  }
  export class KeyCheck {
      ConfirmationCode: string;
      constructor(m: any);
  }
  export class PairResponse {
      Success: any;
      constructor(m: any);
  }
  export class SecretsAndKeyResponse {
      Secrets: Secrets;
      KeyResponse: KeyResponse;
      constructor(secrets: Secrets, keyResponse: KeyResponse);
  }
  export class DropKeysRequest {
      ToMessage(): Message<any>;
  }

}
declare module '@mx51/spi-client-js/PairingHelper' {
  import { PairRequest, SecretsAndKeyResponse, KeyRequest } from '@mx51/spi-client-js/Pairing';
  export const GENERATOR = 2;
  export const GROUP14_2048_BIT_MODP = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF";
  export class PairingHelper {
      static NewPairRequest(): PairRequest;
      GenerateSecretsAndKeyResponse(keyRequest: KeyRequest): SecretsAndKeyResponse;
      _calculateMyPublicKeyAndSecret(theirPublicKey: string): PublicKeyAndSecret;
      DHSecretToSPISecret(secret: string): string;
  }
  export class PublicKeyAndSecret {
      MyPublicKey: string;
      SharedSecretKey: string;
      constructor(myPublicKey: string, sharedSecretKey: string);
  }

}
declare module '@mx51/spi-client-js/PayAtTable' {
  import { Message } from '@mx51/spi-client-js/Messages';
  import { Nullable } from '@mx51/spi-client-js/types';
  export class BillStatusResponse {
      Result: any;
      BillId: any;
      TableId: any;
      OperatorId: any;
      TotalAmount: any;
      OutstandingAmount: any;
      BillData: any;
      constructor(data?: any);
      getBillPaymentHistory(): any;
      static ToBillData(ph: any): string;
      ToMessage(messageId: any): Message<any>;
  }
  export const BillRetrievalResult: {
      SUCCESS: string;
      INVALID_TABLE_ID: string;
      INVALID_BILL_ID: string;
      INVALID_OPERATOR_ID: string;
  };
  export const PaymentType: {
      CARD: string;
      CASH: string;
  };
  export class BillPayment {
      _incomingAdvice: any;
      BillId: any;
      TableId: any;
      OperatorId: any;
      PaymentFlowStarted: any;
      PaymentType: any;
      PurchaseResponse: any;
      PurchaseAmount: any;
      TipAmount: any;
      SurchargeAmount: any;
      constructor(m: any);
  }
  export class PaymentHistoryEntry {
      PaymentType: any;
      PaymentSummary: any;
      constructor(paymentType: any, paymentSummary: any);
      toJSON(): {
          payment_type: any;
          payment_summary: any;
      };
      GetTerminalRefId(): any;
  }
  export class PayAtTableConfig {
      PayAtTableEnabled: any;
      OperatorIdEnabled: any;
      SplitByAmountEnabled: any;
      EqualSplitEnabled: any;
      TableRetrievalEnabled: any;
      TippingEnabled: any;
      SummaryReportEnabled: any;
      LabelPayButton: any;
      LabelOperatorId: any;
      LabelTableId: any;
      AllowedOperatorIds: any;
      constructor();
      ToMessage(messageId: any): Message<any>;
      static FeatureDisableMessage(messageId: any): Message<any>;
  }
  export class GetOpenTablesResponse {
      TableData: Nullable<OpenTablesEntry[]>;
      constructor(TableData?: Nullable<OpenTablesEntry[]>);
      GetOpenTables(): OpenTablesEntry[];
      ToMessage(messageId: any): Message<any>;
  }
  export class OpenTablesEntry {
      TableId: any;
      Label: any;
      BillOutstandingAmount: any;
      constructor(data?: any);
      toJSON(): {
          table_id: any;
          label: any;
          bill_outstanding_amount: any;
      };
  }
  export class BillPaymentFlowEndedResponse {
      BillId: any;
      BillOutstandingAmount: any;
      BillTotalAmount: any;
      OperatorId: any;
      TableId: any;
      CardTotalCount: any;
      CardTotalAmount: any;
      CashTotalCount: any;
      CashTotalAmount: any;
      constructor(m: any);
  }
  export class BillPaymentFlowEndedAckRequest {
      BillId: any;
      Id: any;
      constructor(billId: any);
      ToMessage(): Message<any>;
  }

}
declare module '@mx51/spi-client-js/PingHelper' {
  import { Message } from '@mx51/spi-client-js/Messages';
  export class PongHelper {
      static GeneratePongResponse(ping: any): Message<any>;
  }
  export class PingHelper {
      static GeneratePingRequest(): Message<any>;
  }

}
declare module '@mx51/spi-client-js/PosInfo' {
  import { Message, Data } from '@mx51/spi-client-js/Messages';
  type OtherInfo = {
      spice_version: string;
  } & DeviceInfo;
  interface SetPosInfoRequestData extends Data {
      pos_version: string;
      pos_vendor_id: string;
      library_language: string;
      library_version: string;
      spice_version: string;
      other_info: OtherInfo;
  }
  export class SetPosInfoRequest {
      _version: string;
      _vendorId: string;
      _libraryLanguage: string;
      _libraryVersion: string;
      _spiceVersion: string;
      _otherInfo: object;
      constructor(version: string, vendorId: string, spiceVersion: string, libraryLanguage: string, libraryVersion: string, otherInfo: DeviceInfo);
      toMessage(): Message<SetPosInfoRequestData>;
  }
  export class SetPosInfoResponse {
      _success: boolean;
      _m: Message<Data>;
      constructor(m: Message<Data>);
      isSuccess(): boolean;
      getErrorReason(): string;
      getErrorDetail(): string;
      getResponseValueWithAttribute(attribute: string): unknown;
  }
  export interface DeviceInfo {
      device_system?: string;
  }
  export class DeviceInfo {
      static GetAppDeviceInfo(): DeviceInfo;
  }
  export {};

}
declare module '@mx51/spi-client-js/Preauth' {
  import { Message } from '@mx51/spi-client-js/Messages';
  import { PurchaseResponse, PurchaseData } from '@mx51/spi-client-js/Purchase';
  import { SpiConfig, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  export const PreauthEvents: {
      AccountVerifyRequest: string;
      AccountVerifyResponse: string;
      PreauthOpenRequest: string;
      PreauthOpenResponse: string;
      PreauthTopupRequest: string;
      PreauthTopupResponse: string;
      PreauthExtendRequest: string;
      PreauthExtendResponse: string;
      PreauthPartialCancellationRequest: string;
      PreauthPartialCancellationResponse: string;
      PreauthCancellationRequest: string;
      PreauthCancellationResponse: string;
      PreauthCompleteRequest: string;
      PreauthCompleteResponse: string;
  };
  export class AccountVerifyRequest {
      PosRefId: string;
      constructor(posRefId: string);
      ToMessage(): Message<{
          pos_ref_id: string;
      }>;
  }
  export class AccountVerifyResponse {
      Details: PurchaseResponse;
      PosRefId: string;
      _m: Message<PurchaseData>;
      constructor(m: Message<PurchaseData>);
  }
  export class PreauthOpenRequest {
      PosRefId: string;
      PreauthAmount: number;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(amountCents: number, posRefId: string);
      ToMessage(): Message<{
          pos_ref_id: string;
          preauth_amount: number;
      }>;
  }
  export class PreauthTopupRequest {
      PreauthId: string;
      TopupAmount: number;
      PosRefId: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(preauthId: any, topupAmountCents: any, posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          preauth_id: string;
          topup_amount: number;
      }>;
  }
  export class PreauthPartialCancellationRequest {
      PreauthId: string;
      PartialCancellationAmount: number;
      PosRefId: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(preauthId: any, partialCancellationAmountCents: any, posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          preauth_id: string;
          preauth_cancel_amount: number;
      }>;
  }
  export class PreauthExtendRequest {
      PreauthId: string;
      PosRefId: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(preauthId: any, posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          preauth_id: string;
      }>;
  }
  export class PreauthCancelRequest {
      PreauthId: string;
      PosRefId: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(preauthId: any, posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          preauth_id: string;
      }>;
  }
  export class PreauthCompletionRequest {
      PreauthId: string;
      CompletionAmount: number;
      PosRefId: string;
      SurchargeAmount: number;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(preauthId: any, completionAmountCents: any, posRefId: any, surchargeAmount?: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          preauth_id: string;
          completion_amount: number;
          surcharge_amount: number;
      }>;
  }
  interface PreAuthData extends PurchaseData {
      pos_ref_id: string;
      preauth_id: string;
      transaction_type: string;
      preauth_amount: number;
      existing_preauth_amount: number;
      balance_amount: number;
      completion_amount: number;
      surcharge_amount: number;
      merchant_receipt_printed: boolean;
      customer_receipt_printed: boolean;
  }
  export class PreauthResponse {
      PreauthId: string;
      Details: PurchaseResponse;
      PosRefId: string;
      _m: Message<PreAuthData>;
      constructor(m: Message<PreAuthData>);
      GetBalanceAmount(): number;
      GetPreviousBalanceAmount(): number;
      GetCompletionAmount(): number;
      GetSurchargeAmount(): number;
      WasMerchantReceiptPrinted(): boolean;
      WasCustomerReceiptPrinted(): boolean;
  }
  export {};

}
declare module '@mx51/spi-client-js/Printing' {
  import { Message, Data } from '@mx51/spi-client-js/Messages';
  interface PrintingRequestData extends Data {
      key: string;
      payload: unknown;
  }
  export class PrintingRequest {
      _key: string;
      _payload: string;
      constructor(key: any, payload: any);
      toMessage(): Message<PrintingRequestData>;
  }
  export class PrintingResponse {
      _success: boolean;
      _m: Message<Data>;
      constructor(m: any);
      isSuccess(): boolean;
      getErrorReason(): string;
      getErrorDetail(): string;
      getResponseValueWithAttribute(attribute: any): any;
  }
  type Element = {
      innerText: string;
      scrollTop: () => void;
      scrollHeight: () => void;
  };
  /**
   * This class is a mock printer for the terminal to print Receipts
   */
  export class Printer {
      buffer: string[];
      element: Element;
      constructor(element: any);
      print(...args: any[]): void;
      _render(): void;
      Clear(): void;
  }
  export {};

}
declare module '@mx51/spi-client-js/Purchase' {
  import { Message, Data } from '@mx51/spi-client-js/Messages';
  import { SpiConfig, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  export class PurchaseRequest {
      PosRefId: string;
      PurchaseAmount: number;
      TipAmount: number;
      CashoutAmount: number;
      PromptForCashout: boolean;
      SurchargeAmount: number;
      Config: SpiConfig;
      Options: TransactionOptions;
      Id: string;
      AmountCents: number;
      constructor(amountCents: any, posRefId: any);
      AmountSummary(): string;
      ToMessage(): Message<{
          pos_ref_id: string;
          purchase_amount: number;
          tip_amount: number;
          cash_amount: number;
          prompt_for_cashout: boolean;
          surcharge_amount: number;
      }>;
  }
  export interface PurchaseData {
      pos_ref_id: string;
      purchase_amount: number;
      scheme_name: string;
      rrn: string;
      tip_amount: string;
      surcharge_amount: number;
      cash_amount: number;
      bank_noncash_amount: number;
      bank_cash_amount: number;
      customer_receipt: string;
      merchant_receipt: string;
      host_response_text: string;
      host_response_code: string;
      terminal_ref_id: string;
      card_entry: string;
      account_type: string;
      auth_code: string;
      bank_date: string;
      bank_time: string;
      masked_pan: string;
      terminal_id: string;
      merchant_receipt_printed: boolean;
      customer_receipt_printed: boolean;
      bank_settlement_date: string;
  }
  export class PurchaseResponse {
      _m: Message<PurchaseData>;
      RequestId: string;
      PosRefId: string;
      SchemeName: string;
      SchemeAppName: string;
      Success: boolean;
      constructor(m: Message<PurchaseData>);
      GetRRN(): string;
      GetPurchaseAmount(): number;
      GetTipAmount(): string | 0;
      GetSurchargeAmount(): number;
      GetCashoutAmount(): number;
      GetBankNonCashAmount(): number;
      GetBankCashAmount(): number;
      GetCustomerReceipt(): string;
      GetMerchantReceipt(): string;
      GetResponseText(): string;
      GetResponseCode(): string;
      GetTerminalReferenceId(): string;
      GetCardEntry(): string;
      GetAccountType(): string;
      GetAuthCode(): string;
      GetBankDate(): string;
      GetBankTime(): string;
      GetMaskedPan(): string;
      GetTerminalId(): string;
      WasMerchantReceiptPrinted(): boolean;
      WasCustomerReceiptPrinted(): boolean;
      GetSettlementDate(): Date;
      GetResponseValue(attribute: any): any;
      ToPaymentSummary(): {
          account_type: string;
          auth_code: string;
          bank_date: string;
          bank_time: string;
          host_response_code: string;
          host_response_text: string;
          masked_pan: string;
          purchase_amount: number;
          rrn: string;
          scheme_name: string;
          terminal_id: string;
          terminal_ref_id: string;
          tip_amount: string | number;
          surcharge_amount: number;
      };
  }
  export class CancelTransactionRequest {
      ToMessage(): Message<any>;
  }
  export class CancelTransactionResponse {
      _m: Message<Data>;
      PosRefId: string;
      Success: boolean;
      constructor(m: Message<Data>);
      GetErrorReason(): string;
      GetErrorDetail(): string;
      WasTxnPastPointOfNoReturn(): boolean;
      GetResponseValueWithAttribute(attribute: any): any;
  }
  export class GetTransactionRequest {
      PosRefId: string;
      constructor(posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
      }>;
  }
  interface GetTransactionResponseData extends Data {
      tx: object;
      customer_receipt: string;
      merchant_receipt: string;
  }
  export class GetTransactionResponse {
      _m: Message<GetTransactionResponseData>;
      Success: boolean;
      constructor(m: Message<GetTransactionResponseData>);
      GetPosRefId(): string;
      GetError(): string;
      GetTxMessage(): Message<object>;
      PosRefIdNotFound(): boolean;
      PosRefIdInvalid(): boolean;
      PosRefIdMissing(): boolean;
      WasRetrievedSuccessfully(): boolean;
      IsTransactionInProgress(): boolean;
      IsWaitingForSignatureResponse(): boolean;
      IsWaitingForAuthCode(): boolean;
      IsSomethingElseBlocking(): boolean;
      CopyMerchantReceiptToCustomerReceipt(): void;
  }
  export class GetLastTransactionRequest {
      ToMessage(): Message<any>;
  }
  interface GetLastTransactionData extends Data {
      bank_settlement_date: string;
      bank_date: string;
      bank_time: string;
      transaction_type: string;
      pos_ref_id: string;
      bank_noncash_amount: number;
      scheme_name: string;
      amount_purchase: number;
      amount_transaction_type: string;
      rrn: string;
      host_response_text: string;
      host_response_code: string;
      customer_receipt: string;
      merchant_receipt: string;
  }
  export class GetLastTransactionResponse {
      _m: Message<GetLastTransactionData>;
      constructor(m: any);
      WasRetrievedSuccessfully(): boolean;
      WasOperationInProgressError(): boolean;
      IsWaitingForSignatureResponse(): boolean;
      IsWaitingForAuthCode(): boolean;
      IsStillInProgress(posRefId: any): boolean;
      GetSuccessState(): string;
      WasSuccessfulTx(): boolean;
      GetTxType(): string;
      GetPosRefId(): string;
      GetBankNonCashAmount(): number;
      GetSchemeApp(): string;
      GetSchemeName(): string;
      GetAmount(): number;
      GetTransactionAmount(): string;
      GetBankDateTimeString(): string;
      GetRRN(): string;
      GetResponseText(): string;
      GetResponseCode(): string;
      CopyMerchantReceiptToCustomerReceipt(): void;
  }
  export class RefundRequest {
      AmountCents: number;
      Id: string;
      PosRefId: string;
      SuppressMerchantPassword: boolean;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(amountCents: any, posRefId: any, suppressMerchantPassword: any);
      ToMessage(): Message<{
          refund_amount: number;
          pos_ref_id: string;
          suppress_merchant_password: boolean;
      }>;
  }
  interface RefundResponseData {
      pos_ref_id: string;
      scheme_name: string;
      refund_amount: number;
      rrn: string;
      customer_receipt: string;
      merchant_receipt: string;
      host_response_text: string;
      host_response_code: string;
      terminal_ref_id: string;
      terminal_id: string;
      card_entry: string;
      account_type: string;
      auth_code: number;
      bank_date: string;
      bank_time: string;
      masked_pan: string;
      merchant_receipt_printed: boolean;
      customer_receipt_printed: boolean;
      bank_settlement_date: string;
  }
  export class RefundResponse {
      _m: Message<RefundResponseData>;
      RequestId: string;
      PosRefId: string;
      SchemeName: string;
      SchemeAppName: string;
      Success: boolean;
      constructor(m: Message<RefundResponseData>);
      GetRefundAmount(): number;
      GetRRN(): string;
      GetCustomerReceipt(): string;
      GetMerchantReceipt(): string;
      GetResponseText(): string;
      GetResponseCode(): string;
      GetTerminalReferenceId(): string;
      GetCardEntry(): string;
      GetAccountType(): string;
      GetAuthCode(): number | "";
      GetBankDate(): string;
      GetBankTime(): string;
      GetMaskedPan(): string;
      GetTerminalId(): string;
      WasMerchantReceiptPrinted(): boolean;
      WasCustomerReceiptPrinted(): boolean;
      GetSettlementDate(): Date;
      GetResponseValue(attribute: any): any;
  }
  interface SignatureRequiredData {
      pos_ref_id: string;
      merchant_receipt: string;
  }
  export class SignatureRequired {
      RequestId: string;
      PosRefId: string;
      _receiptToSign: string;
      constructor(m: Message<SignatureRequiredData>);
      SignatureRequired(posRefId: any, requestId: any, receiptToSign: any): void;
      GetMerchantReceipt(): string;
  }
  export class SignatureDecline {
      PosRefId: string;
      constructor(posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
      }>;
  }
  export class SignatureAccept {
      PosRefId: string;
      constructor(posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
      }>;
  }
  export class MotoPurchaseRequest {
      PosRefId: string;
      PurchaseAmount: number;
      SurchargeAmount: number;
      SuppressMerchantPassword: boolean;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(amountCents: any, posRefId: any, surchargeAmount?: any, SuppressMerchantPassword?: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          purchase_amount: number;
          surcharge_amount: number;
          suppress_merchant_password: boolean;
      }>;
  }
  export class MotoPurchaseResponse {
      PurchaseResponse: PurchaseResponse;
      PosRefId: string;
      constructor(m: any);
  }
  export class PhoneForAuthRequired {
      PosRefId: string;
      RequestId: string;
      _phoneNumber: string;
      _merchantId: string;
      constructor(...args: any[]);
      GetPhoneNumber(): string;
      GetMerchantId(): string;
  }
  export class AuthCodeAdvice {
      PosRefId: string;
      AuthCode: string;
      constructor(posRefId: any, authCode: any);
      ToMessage(): Message<{
          pos_ref_id: string;
          auth_code: string;
      }>;
  }
  export class TransactionUpdate {
      DisplayMessageCode: string;
      DisplayMessageText: string;
      constructor(m: any);
      GetDisplayMessageCode(): string;
      GetDisplayMessageText(): string;
  }
  export {};

}
declare module '@mx51/spi-client-js/PurchaseHelper' {
  import { PurchaseRequest, RefundRequest } from '@mx51/spi-client-js/Purchase';
  export class PurchaseHelper {
      static CreatePurchaseRequest(amountCents: any, purchaseId: any): PurchaseRequest;
      static CreatePurchaseRequestV2(posRefId: any, purchaseAmount: any, tipAmount: any, cashoutAmount: any, promptForCashout: any, surchargeAmount: any): PurchaseRequest & {
          CashoutAmount: any;
          TipAmount: any;
          PromptForCashout: any;
          SurchargeAmount: any;
      };
      static CreateRefundRequest(amountCents: any, purchaseId: any, suppressMerchantPassword: any): RefundRequest;
  }

}
declare module '@mx51/spi-client-js/RequestIdHelper' {
  export class RequestIdHelper {
      static Id(prefix: any): any;
  }

}
declare module '@mx51/spi-client-js/Reversal' {
  import { Data, Message } from '@mx51/spi-client-js/Messages';
  export class ReversalRequest {
      PosRefId: string;
      constructor(posRefId: any);
      ToMessage(): Message<{
          pos_ref_id: string;
      }>;
  }
  export class ReversalResponse {
      _m: Message<Data>;
      PosRefId: string;
      Success: boolean;
      constructor(m: Message<Data>);
      GetErrorReason(): string;
      GetErrorDetail(): string;
  }

}
declare module '@mx51/spi-client-js/Secrets' {
  export class Secrets {
      EncKey: string;
      HmacKey: string;
      constructor(encKey: any, hmacKey: any);
      static save(EncKey: any, HmacKey: any): void;
      static restore(): Secrets;
      static isSaved(): string;
      static Reset(): void;
  }

}
declare module '@mx51/spi-client-js/Service/AnalyticsService' {
  import { SpiFlow } from "@mx51/spi-client-js/SpiModels";
  import { Nullable } from "@mx51/spi-client-js/types";
  export class TransactionReport {
      PosVendorId: Nullable<string>;
      PosVersion: Nullable<string>;
      LibraryLanguage: Nullable<string>;
      LibraryVersion: Nullable<string>;
      PosRefId: Nullable<string>;
      SerialNumber: Nullable<string>;
      Event: Nullable<string>;
      TxType: Nullable<string>;
      TxResult: Nullable<string>;
      TxStartTime: Nullable<number>;
      TxEndTime: Nullable<number>;
      DurationMs: Nullable<number>;
      CurrentFlow: Nullable<SpiFlow>;
      CurrentTxFlowState: Nullable<string>;
      CurrentStatus: Nullable<string>;
      ToMessage(): {
          pos_vendor_id: string;
          pos_version: string;
          library_language: string;
          library_version: string;
          pos_ref_id: string;
          serial_number: string;
          event: string;
          tx_type: string;
          tx_result: string;
          tx_start_ts_ms: number;
          tx_end_ts_ms: number;
          duration_ms: number;
          current_flow: SpiFlow;
          current_tx_flow_state: string;
          current_status: string;
      };
  }
  export class AnalyticsService {
      static ReportTransaction(transactionReport: TransactionReport, apiKey: Nullable<string>, tenantCode: Nullable<string>, isTestMode: boolean): Promise<void>;
  }

}
declare module '@mx51/spi-client-js/Service/DeviceService' {
  import { Nullable } from "@mx51/spi-client-js/types";
  export class DeviceAddressStatus {
      ip: Nullable<string>;
      fqdn: Nullable<string>;
      LastUpdated: Nullable<string>;
      UseSecureWebSockets: boolean;
      DeviceAddressResponseCode: Nullable<string>;
      ResponseStatusDescription: Nullable<string>;
      ResponseMessage: Nullable<string>;
      get Address(): string;
      set Address(address: string);
      constructor(useSecureWebSockets: boolean);
  }
  export const DeviceAddressResponseCode: {
      SUCCESS: string;
      INVALID_SERIAL_NUMBER: string;
      ADDRESS_NOT_CHANGED: string;
      SERIAL_NUMBER_NOT_CHANGED: string;
      DEVICE_SERVICE_ERROR: string;
  };
  export const HttpStatusCode: {
      NotFound: number;
      OK: number;
  };
  export class DeviceAddressService {
      static RetrieveDeviceAddress(params: {
          serialNumber: string;
          tenantCode: string;
          isSecureConnection: boolean;
          isTestMode: boolean;
          apiKey?: string;
          environmentCode?: string;
      }): Promise<Response | unknown>;
  }

}
declare module '@mx51/spi-client-js/Service/TenantsService' {
  interface RetrieveTenantsListResponse {
      data: Array<{
          code: string;
          name: string;
      }>;
      success: boolean;
  }
  export class TenantsService {
      static RetrieveTenantsList(posVendorId: string, apiKey: string, countryCode: string): Promise<RetrieveTenantsListResponse>;
  }
  export {};

}
declare module '@mx51/spi-client-js/Settlement' {
  import { Message, Data } from '@mx51/spi-client-js/Messages';
  import { SpiConfig, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  export class SettleRequest {
      Config: SpiConfig;
      Options: TransactionOptions;
      readonly Id: string;
      constructor(id: string);
      ToMessage(): Message<Data>;
  }
  interface SettlementData extends Data {
      accumulated_settle_by_acquirer_count?: string;
      accumulated_settle_by_acquirer_value?: string;
      accumulated_total_count?: string;
      accumulated_total_value?: string;
      host_response_text?: string;
      merchant_receipt?: string;
      transaction_range?: string;
      terminal_id?: string;
      merchant_receipt_printed?: boolean;
      settlement_period_start_time: string;
      settlement_period_end_time: string;
      settlement_period_start_date: string;
      settlement_period_end_date: string;
      settlement_triggered_time: string;
      settlement_triggered_date: string;
      schemes: Scheme[];
  }
  interface Scheme {
      scheme_name: string;
      total_count: string;
      total_value: string;
      settle_by_acquirer: string;
  }
  export class Settlement {
      RequestId: string;
      Success: boolean;
      private readonly _m;
      constructor(m: Message<SettlementData>);
      GetSettleByAcquirerCount(): string;
      GetSettleByAcquirerValue(): string;
      GetTotalCount(): string;
      GetTotalValue(): string;
      GetPeriodStartTime(): Date;
      GetPeriodEndTime(): Date;
      GetTriggeredTime(): Date;
      GetResponseText(): string;
      GetReceipt(): string;
      GetTransactionRange(): string;
      GetTerminalId(): string;
      WasMerchantReceiptPrinted(): boolean;
      GetSchemeSettlementEntries(): SchemeSettlementEntry[];
  }
  export class SchemeSettlementEntry {
      SchemeName: string;
      SettleByAcquirer: boolean;
      TotalCount: number;
      TotalValue: number;
      constructor(...args: [Scheme] | [string, boolean, number, number]);
      ToString(): string;
  }
  export class SettlementEnquiryRequest {
      Id: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(id: string);
      ToMessage(): Message<Data>;
  }
  export {};

}
declare module '@mx51/spi-client-js/Spi' {
  /// <reference types="node" />
  import { TransactionReport } from '@mx51/spi-client-js/Service/AnalyticsService';
  import { Message, MessageStamp, Data } from '@mx51/spi-client-js/Messages';
  import { SpiConfig, SpiFlow, PairingFlowState, TransactionFlowState, InitiateTxResult, MidTxResult, SubmitAuthCodeResult, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  import { Connection } from '@mx51/spi-client-js/Connection';
  import { SpiPayAtTable } from '@mx51/spi-client-js/SpiPayAtTable';
  import { SpiPreauth } from '@mx51/spi-client-js/SpiPreauth';
  import { DeviceAddressStatus } from '@mx51/spi-client-js/Service/DeviceService';
  import { Secrets } from '@mx51/spi-client-js/Secrets';
  import { Nullable } from '@mx51/spi-client-js/types';
  const SPI_VERSION = "2.9.9";
  interface EventBus {
      addEventListener: (type: string, cb: (e: CustomEvent) => void) => void;
      removeEventListener: (type: string, cb: (e: CustomEvent) => void) => void;
      dispatchEvent: (event: CustomEvent) => void;
      once?: (type: string, cb: (e: CustomEvent) => void) => void;
  }
  class Spi {
      _currentStatus: string;
      _eventBus: EventBus;
      _posId: string;
      _serialNumber: string;
      _secrets: Secrets;
      _previousSecrets: Secrets;
      _secretsRetryAttempts: number;
      _maxSecretsRetryAttempts: number;
      mostRecentPingSent: Message<Data>;
      _eftposAddress: string;
      _log: Console;
      Config: SpiConfig;
      _conn: Connection;
      CurrentDeviceStatus: DeviceAddressStatus;
      _deviceApiKey: string;
      _tenantCode: string;
      private _environmentCode?;
      _terminalModel: string;
      _inTestMode: boolean;
      _autoAddressResolutionEnabled: boolean;
      _spiMessageStamp: MessageStamp;
      _hasSetInfo: boolean;
      _posVendorId: string;
      _posVersion: string;
      _libraryLanguage: string;
      _spiceVersion: string;
      _transactionReport: TransactionReport;
      _mostRecentPingSent: Message<Data>;
      _mostRecentPongReceived: Message<Data>;
      _missedPongsCount: number;
      _retriesSinceLastDeviceAddressResolution: number;
      _mostRecentLoginResponse: null;
      _pongTimeout: number;
      _pingFrequency: number;
      _readyToTransact: null;
      _periodicPingThread: Nullable<NodeJS.Timer>;
      _transactionMonitoringThread: Nullable<NodeJS.Timer>;
      _txMonitorCheckFrequency: number;
      _checkOnTxFrequency: number;
      _maxWaitForCancelTx: number;
      _sleepBeforeReconnectMs: number;
      _missedPongsToDisconnect: number;
      _retriesBeforeResolvingDeviceAddress: number;
      _retriesSinceLastPairing: number;
      _retriesBeforePairing: number;
      _regexItemsForEftposAddress: RegExp;
      _regexItemsForFqdnEftposAddress: RegExp;
      _regexItemsForPosId: RegExp;
      CurrentFlow: SpiFlow;
      CurrentPairingFlowState: PairingFlowState;
      CurrentTxFlowState: TransactionFlowState;
      _spiPat: SpiPayAtTable;
      _spiPreauth: SpiPreauth;
      posVendorId: string;
      _mostRecentPingSentTime: number;
      _forceSecureWebSockets: boolean;
      get CurrentStatus(): string;
      set CurrentStatus(value: string);
      set EnvironmentCode(value: string);
      constructor(posId: string, serialNumber: string, eftposAddress: string, secrets: Nullable<Secrets>);
      EnablePayAtTable(): SpiPayAtTable;
      DisablePayAtTable(): SpiPayAtTable;
      EnablePreauth(): SpiPreauth;
      Start(): void;
      SetEventBus(eventBus: any): boolean;
      SetAcquirerCode(acquirerCode: string): void;
      SetTenantCode(tenantCode: string): boolean;
      SetDeviceApiKey(deviceApiKey: string): boolean;
      SetSerialNumber(serialNumber: string): boolean;
      SetAutoAddressResolution(autoAddressResolutionEnable: boolean): boolean;
      SetTestMode(testMode: boolean): boolean;
      SetSecureWebSockets(useSecureWebSockets: boolean): void;
      SetPosId(posId: string): boolean;
      SetEftposAddress(address: string): boolean;
      static GetVersion(): string;
      /**
       * Sets values used to identify the POS software to the EFTPOS terminal.
       * Must be set before starting!
       *
       * @param posVendorId Vendor identifier of the POS itself.
       * @param posVersion  Version string of the POS itself.
       */
      SetPosInfo(posVendorId: string, posVersion: string): void;
      SetAdaptorPosInfo(): boolean;
      SetAdaptorInfo(adaptorVersion: string): void;
      AckFlowEndedAndBackToIdle(): boolean;
      Pair(): boolean;
      PairingConfirmCode(): void;
      PairingCancel(): void;
      Unpair(): boolean;
      InitiatePurchaseTx(posRefId: string, amountCents: number): InitiateTxResult;
      InitiatePurchaseTxV2(posRefId: string, purchaseAmount: number, tipAmount: number, cashoutAmount: number, promptForCashout: boolean, options?: TransactionOptions, surchargeAmount?: number): InitiateTxResult;
      InitiateRefundTx(posRefId: string, amountCents: number, suppressMerchantPassword?: boolean, options?: TransactionOptions): InitiateTxResult;
      AcceptSignature(accepted: boolean): MidTxResult;
      SubmitAuthCode(authCode: string): SubmitAuthCodeResult;
      CancelTransaction(): MidTxResult;
      InitiateCashoutOnlyTx(posRefId: string, amountCents: number, surchargeAmount?: number, options?: TransactionOptions): InitiateTxResult;
      InitiateMotoPurchaseTx(posRefId: string, amountCents: number, surchargeAmount?: number, suppressMerchantPassword?: boolean, options?: TransactionOptions): InitiateTxResult;
      InitiateSettleTx(posRefId: string, options?: TransactionOptions): InitiateTxResult;
      InitiateSettlementEnquiry(posRefId: string, options?: TransactionOptions): InitiateTxResult;
      InitiateGetLastTx(): InitiateTxResult;
      InitiateGetTx(posRefId: string): InitiateTxResult;
      InitiateRecovery(posRefId: string, txType: any): InitiateTxResult;
      InitiateReversal(posRefId: string): InitiateTxResult;
      InitiateZipRefundTx(posRefId: string, refundAmount: number, originalReceiptNumber: string, options?: TransactionOptions): InitiateTxResult;
      InitiateZipPurchaseTx(posRefId: string, purchaseAmount: number, description: string, storeCode: string, options?: TransactionOptions): InitiateTxResult;
      PrintReceipt(key: any, payload: any): void;
      static GetAvailableTenants(posVendorId: string, apiKey: string, countryCode: string): Promise<{
          Data: {
              code: string;
              name: string;
          }[];
      }>;
      GetTerminalStatus(): void;
      GetTerminalConfiguration(): void;
      GetTerminalAddress(): Promise<any>;
      _handleKeyRequest(m: any): void;
      _handleKeyCheck(m: any): void;
      _handlePairResponse(m: any): void;
      _handleDropKeysAdvice(m: any): void;
      _onPairingSuccess(): void;
      _onPairingFailed(): void;
      _doUnpair(): void;
      _handleKeyRollingRequest(m: any): void;
      _handleInvalidHmacSignature(): void;
      _handleSignatureRequired(m: any): void;
      _handleAuthCodeRequired(m: any): void;
      _handlePurchaseResponse(m: any): void;
      _handleCashoutOnlyResponse(m: any): void;
      _handleMotoPurchaseResponse(m: any): void;
      _handleRefundResponse(m: any): void;
      _handleSettleResponse(m: any): void;
      _handleSettlementEnquiryResponse(m: any): void;
      _handleReversalTransaction(m: any): void;
      _handleErrorEvent(m: any): void;
      _handleGetTransactionResponse(m: any): void;
      _handleGetLastTransactionResponse(m: any): void;
      _handleCancelTransactionResponse(m: any): void;
      _handleSetPosInfoResponse(m: any): void;
      _startTransactionMonitoringThread(): void;
      PrintingResponse(m: any): void;
      TerminalStatusResponse(m: any): void;
      TerminalConfigurationResponse(m: any): void;
      BatteryLevelChanged(m: any): void;
      TransactionUpdateMessage(m: any): void;
      _handlePrintingResponse(m: any): void;
      _handleTransactionUpdateMessage(m: any): void;
      _handleTerminalStatusResponse(m: any): void;
      _handleTerminalConfigurationResponse(m: any): void;
      _handleBatteryLevelChanged(m: any): void;
      _isPrintingConfigEnabled(): boolean;
      _handleZipPurchaseResponse(m: any): void;
      _handleZipRefundResponse(m: any): void;
      _resetConn(): void;
      _onSpiConnectionStatusChanged(state: any): void;
      _startPeriodicPing(): void;
      _periodicPing(): void;
      _onReadyToTransact(): void;
      _callSetPosInfo(): void;
      _stopPeriodicPing(): void;
      _doPing(): void;
      _handleIncomingPong(m: any): void;
      _handleIncomingPing(m: any): void;
      _callGetTransaction(posRefId: string): void;
      _onSpiMessageReceived(messageJson: any): void;
      _onWsErrorReceived(error: any): void;
      _send(message: any): boolean;
      _isPosIdValid(posId: any): boolean;
      _isEftposAddressValid(eftposAddress: any): boolean;
      HasSerialNumberChanged(updatedSerialNumber: string): boolean;
      _autoResolveEftposAddress(): Promise<void>;
      _sendTransactionReport(): Promise<void>;
      _isUsingHttps(): boolean;
      _isSecureConnection(): boolean;
      _getConnectionAddress(address: any, tenantCode: any, posId: any): string;
  }
  export { Spi, SPI_VERSION };

}
declare module '@mx51/spi-client-js/SpiModels' {
  import { Message, Data } from '@mx51/spi-client-js/Messages';
  export const SpiStatus: {
      PairedConnected: string;
      PairedConnecting: string;
      Unpaired: string;
  };
  export enum SpiFlow {
      Pairing = "Pairing",
      Transaction = "Transaction",
      Idle = "Idle"
  }
  export class PairingFlowState {
      Message: string;
      AwaitingCheckFromEftpos: boolean;
      AwaitingCheckFromPos: boolean;
      ConfirmationCode: string;
      Finished: boolean;
      Successful: boolean;
      constructor(state: any);
  }
  export const TransactionType: {
      AccountVerify: string;
      CashoutOnly: string;
      GetTransaction: string;
      GetLastTransaction: string;
      MOTO: string;
      Preauth: string;
      Purchase: string;
      Refund: string;
      Reversal: string;
      Settle: string;
      SettlementEnquiry: string;
      ZipPurchase: string;
      ZipRefund: string;
  };
  export class InitiateTxResult {
      Initiated: boolean;
      Message: string;
      constructor(initiated: boolean, message: string);
  }
  export class MidTxResult {
      Valid: boolean;
      Message: string;
      constructor(valid: boolean, message: string);
  }
  export class TransactionFlowState {
      PosRefId: string;
      Id: string;
      Type: string;
      DisplayMessage: string;
      AmountCents: number;
      RequestSent: boolean;
      RequestTime: number;
      LastStateRequestTime: number;
      GtRequestId: string;
      AttemptingToCancel: boolean;
      AwaitingSignatureCheck: boolean;
      AwaitingPhoneForAuth: boolean;
      Finished: boolean;
      Success: string;
      Response: boolean;
      SignatureRequiredMessage: boolean;
      PhoneForAuthRequiredMessage: boolean;
      CancelAttemptTime: number;
      Request: Message<Data>;
      AwaitingGtResponse: boolean;
      CompletedTime: number;
      constructor(posRefId: string, type: string, amountCents: number, message: Message<Data>, msg: string);
      Sent(msg: any): void;
      Cancelling(msg: any): void;
      CancelFailed(msg: any): void;
      CallingGt(gtRequestId: any): void;
      GotGtResponse(): void;
      Failed(response: any, msg: any): void;
      SignatureRequired(spiMessage: any, msg: any): void;
      SignatureResponded(msg: any): void;
      PhoneForAuthRequired(spiMessage: any, msg: any): void;
      AuthCodeSent(msg: any): void;
      Completed(state: any, response: any, msg: any): void;
      UnknownCompleted(msg: any): void;
  }
  export class SubmitAuthCodeResult {
      ValidFormat: boolean;
      Message: string;
      constructor(validFormat: boolean, message: string);
  }
  export class SpiConfig {
      PrintMerchantCopy: boolean;
      PromptForCustomerCopyOnEftpos: boolean;
      SignatureFlowOnEftpos: boolean;
      EnabledPrintMerchantCopy: boolean;
      EnabledPromptForCustomerCopyOnEftpos: boolean;
      EnabledSignatureFlowOnEftpos: boolean;
      constructor();
      AddReceiptConfig(messageData: any): any;
      ToString(): string;
  }
  interface MessageData {
      customer_receipt_header?: string;
      customer_receipt_footer?: string;
      merchant_receipt_header?: string;
      merchant_receipt_footer?: string;
      pos_ref_id?: string;
      cash_amount?: number;
      surcharge_amount?: number;
  }
  export class TransactionOptions {
      _customerReceiptHeader: string;
      _customerReceiptFooter: string;
      _merchantReceiptHeader: string;
      _merchantReceiptFooter: string;
      constructor();
      SetCustomerReceiptHeader(customerReceiptHeader: string): void;
      SetCustomerReceiptFooter(customerReceiptFooter: string): void;
      SetMerchantReceiptHeader(merchantReceiptHeader: string): void;
      SetMerchantReceiptFooter(merchantReceiptFooter: string): void;
      AddOptions(messageData: MessageData): MessageData;
  }
  export {};

}
declare module '@mx51/spi-client-js/SpiPayAtTable' {
  import { BillStatusResponse, GetOpenTablesResponse, PayAtTableConfig } from '@mx51/spi-client-js/PayAtTable';
  import { Spi } from '@mx51/spi-client-js/Spi';
  import { Data, Message } from '@mx51/spi-client-js/Messages';
  interface PayAtTableData extends Data {
      operator_id: string;
      table_id: string;
      payment_flow_started: boolean;
  }
  export class SpiPayAtTable {
      _spi: Spi;
      _log: Console;
      Config: PayAtTableConfig;
      constructor(spi: any);
      GetBillStatus(billId: any, tableId: any, operatorId: any, paymentFlowStarted: any): BillStatusResponse;
      BillPaymentReceived(billPayment: any, updatedBillData: any): BillStatusResponse;
      GetOpenTables(operatorId: any): GetOpenTablesResponse;
      BillPaymentFlowEnded(message: any): void;
      PushPayAtTableConfig(): void;
      _handleGetBillDetailsRequest(m: Message<PayAtTableData>): Promise<void>;
      _handleBillPaymentAdvice(m: any): Promise<void>;
      _handleGetTableConfig(m: any): void;
      _handleGetOpenTablesRequest(m: any): Promise<void>;
      _handleBillPaymentFlowEnded(m: any): Promise<void>;
  }
  export {};

}
declare module '@mx51/spi-client-js/SpiPreauth' {
  import { Spi } from '@mx51/spi-client-js/Spi';
  import { InitiateTxResult, SpiConfig, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  export class SpiPreauth {
      _spi: Spi;
      _log: any;
      Config: SpiConfig;
      constructor(spi: any);
      InitiateAccountVerifyTx(posRefId: string): InitiateTxResult;
      InitiateOpenTx(posRefId: string, amountCents: number, options?: TransactionOptions): InitiateTxResult;
      InitiateTopupTx(posRefId: string, preauthId: number, amountCents: number, options?: TransactionOptions): InitiateTxResult;
      InitiatePartialCancellationTx(posRefId: string, preauthId: number, amountCents: number, options?: TransactionOptions): InitiateTxResult;
      InitiateExtendTx(posRefId: string, preauthId: number, options?: TransactionOptions): InitiateTxResult;
      InitiateCompletionTx(posRefId: string, preauthId: number, amountCents: number, surchargeAmount?: number, options?: TransactionOptions): InitiateTxResult;
      InitiateCancelTx(posRefId: string, preauthId: number, options?: TransactionOptions): InitiateTxResult;
      _initiatePreauthTx(tfs: any, sentMsg: any): InitiateTxResult;
      _handlePreauthMessage(m: any): void;
      _handleAccountVerifyResponse(m: any): void;
      _handlePreauthResponse(m: any): void;
      static IsPreauthEvent(eventName: any): boolean;
  }

}
declare module '@mx51/spi-client-js/TerminalConfiguration' {
  import { Message } from '@mx51/spi-client-js/Messages';
  export class TerminalConfigurationRequest {
      ToMessage(): Message<{}>;
  }
  export class TerminalConfigurationResponse {
      _success: boolean;
      _m: any;
      constructor(m: any);
      isSuccess(): boolean;
      GetCommsSelected(): any;
      GetMerchantId(): any;
      GetPAVersion(): any;
      GetPaymentInterfaceVersion(): any;
      GetPluginVersion(): any;
      GetSerialNumber(): any;
      GetTerminalId(): any;
      GetTerminalModel(): any;
  }

}
declare module '@mx51/spi-client-js/TerminalHelper' {
  export class TerminalHelper {
      static IsPrinterAvailable(terminalModel: any): boolean;
  }

}
declare module '@mx51/spi-client-js/TerminalStatus' {
  import { Message } from '@mx51/spi-client-js/Messages';
  export class TerminalStatusRequest {
      ToMessage(): Message<{}>;
  }
  export class TerminalStatusResponse {
      _m: any;
      constructor(m: any);
      GetStatus(): any;
      GetBatteryLevel(): number;
      IsCharging(): boolean;
  }
  export class TerminalBattery {
      BatteryLevel: number;
      constructor(m: any);
  }

}
declare module '@mx51/spi-client-js/TransactionReportHelper' {
  import { TransactionReport } from '@mx51/spi-client-js/Service/AnalyticsService';
  export class TransactionReportHelper {
      static CreateTransactionReportEnvelope(posVendorId: any, posVersion: any, libraryLanguage: any, libraryVersion: any, serialNumber: any): TransactionReport & {
          PosVendorId: any;
          PosVersion: any;
          LibraryLanguage: any;
          LibraryVersion: any;
          SerialNumber: any;
      };
  }

}
declare module '@mx51/spi-client-js/ZipTransactions' {
  import { Message } from '@mx51/spi-client-js/Messages';
  import { SpiConfig, TransactionOptions } from '@mx51/spi-client-js/SpiModels';
  interface ZipPurchaseRequestMessageData {
      pos_ref_id: string;
      purchase_amount: number;
      zip_data: {
          store_code: string;
      };
      basket: {
          description: string;
      };
      merchant_receipt_header: string;
      merchant_receipt_footer: string;
      customer_receipt_header: string;
      customer_receipt_footer: string;
  }
  export class ZipPurchaseRequest {
      PosRefId: string;
      PurchaseAmount: number;
      StoreCode: string;
      Description: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(purchaseAmount: any, posRefId: any);
      AmountSummary(): string;
      ToMessage(): Message<ZipPurchaseRequestMessageData>;
  }
  export class ZipPurchaseResponse {
      _m: any;
      PosRefId: string;
      Success: boolean;
      constructor(m: any);
      GetPurchaseAmount(): any;
      GetCustomerReceipt(): any;
      GetMerchantReceipt(): any;
      GetResponseText(): any;
      GetResponseCode(): any;
      GetBankDate(): any;
      GetBankTime(): any;
      GetZipData(): any;
      WasMerchantReceiptPrinted(): any;
      WasCustomerReceiptPrinted(): any;
  }
  interface ZipRefundRequestMessageData {
      pos_ref_id: string;
      refund_amount: number;
      zip_data: {
          original_receipt_number: string;
      };
      merchant_receipt_header: string;
      merchant_receipt_footer: string;
      customer_receipt_header: string;
      customer_receipt_footer: string;
  }
  export class ZipRefundRequest {
      PosRefId: string;
      RefundAmount: number;
      OriginalReceiptNumber: string;
      Config: SpiConfig;
      Options: TransactionOptions;
      constructor(refundAmount: any, posRefId: any);
      ToMessage(): Message<ZipRefundRequestMessageData>;
  }
  export class ZipRefundResponse {
      _m: any;
      PosRefId: string;
      Success: boolean;
      constructor(m: any);
      GetRefundAmount(): any;
      GetCustomerReceipt(): any;
      GetMerchantReceipt(): any;
      GetResponseText(): any;
      GetResponseCode(): any;
      GetBankDate(): any;
      GetBankTime(): any;
      GetZipData(): any;
      WasMerchantReceiptPrinted(): any;
      WasCustomerReceiptPrinted(): any;
  }
  export class ZipDataEntry {
      StoreCode: string;
      LocationId: string;
      ReceiptNumber: number;
      OriginalReceiptNumber: number;
      constructor();
  }
  export {};

}
declare module '@mx51/spi-client-js/index' {
  export { Spi } from '@mx51/spi-client-js/Spi';
  export { Logger } from '@mx51/spi-client-js/Logger';
  export { Secrets } from '@mx51/spi-client-js/Secrets';
  export { SuccessState } from '@mx51/spi-client-js/Messages';
  export { TransactionOptions, TransactionType, SpiFlow, SpiStatus, TransactionFlowState } from '@mx51/spi-client-js/SpiModels';
  export { PrintingResponse } from '@mx51/spi-client-js/Printing';
  export { RefundResponse, PurchaseResponse, GetLastTransactionResponse, MotoPurchaseResponse, TransactionUpdate } from '@mx51/spi-client-js/Purchase';
  export { TerminalStatusResponse, TerminalBattery } from '@mx51/spi-client-js/TerminalStatus';
  export { TerminalConfigurationRequest, TerminalConfigurationResponse } from '@mx51/spi-client-js/TerminalConfiguration';
  export { CashoutOnlyResponse } from '@mx51/spi-client-js/Cashout';
  export { Settlement } from '@mx51/spi-client-js/Settlement';
  export { RequestIdHelper } from '@mx51/spi-client-js/RequestIdHelper';
  export { DeviceAddressResponseCode } from '@mx51/spi-client-js/Service/DeviceService';
  export { ReversalResponse } from '@mx51/spi-client-js/Reversal';
  export { BillStatusResponse, BillRetrievalResult, GetOpenTablesResponse, OpenTablesEntry, BillPaymentFlowEndedResponse } from '@mx51/spi-client-js/PayAtTable';
  export { AccountVerifyResponse, PreauthResponse } from '@mx51/spi-client-js/Preauth';

}
declare module '@mx51/spi-client-js/types' {
  export type Nullable<T> = T | null;
  export type StringOrNumber = string | number;
  export interface TransactionData {
      pos_ref_id: string;
      bank_settlement_date: string;
      bank_date: string;
      bank_time: string;
      transaction_type: string;
      bank_noncash_amount: number;
      scheme_name: string;
      amount_purchase: number;
      amount_transaction_type: string;
      rrn: string;
      host_response_text: string;
      host_response_code: string;
      customer_receipt: string;
      merchant_receipt: string;
      masked_pan: string;
      terminal_id: string;
      merchant_receipt_printed: boolean;
      customer_receipt_printed: boolean;
  }

}
declare module '@mx51/spi-client-js' {
  import main = require('@mx51/spi-client-js/index');
  export = main;
}