const loading = {
  show: () => {
    $("#loading").show();
  },
  hide: () => {
    $("#loading").hide();
  },
};

const isValidInputMachineID = (str) => {
  if (str == null || str.length > 16) {
    return false;
  }
  //字母，数字或横线
  var $sz = "^[A-Za-z0-9]+$";
  var urlReg = new RegExp($sz);
  return urlReg.test(str);
};

const isValidInputEFTPosID = (str) => {
  if (str == null || str.length < 4) {
    return false;
  }
  //字母，数字或横线
  var $sz = "^[A-Za-z0-9-]+$";
  var urlReg = new RegExp($sz);
  return urlReg.test(str);
};

const isValidInputAddress = (str) => {
  if (str == null || str.length < 4) {
    return false;
  }
  var domainRegExp =
    "^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$";
  var urlReg = new RegExp(domainRegExp);
  if (!urlReg.test(str)) {
    var ipRegExp =
      "^((([1-9]|([1-9]d)|(1dd)|(2([0-4]d|5[0-5])))).)((([0-9]|([1-9]d)|(1dd)|(2([0-4]d|5[0-5])))).){2}(([1-9]|([1-9]d)|(1dd)|(2([0-4]d|5[0-5]))))$";
    urlReg = new RegExp(ipRegExp);
    return urlReg.test(str);
  }
  return true;
};

const renderValue = (value, type, precision = 2) => {
  if (type === "percent") {
    return (parseFloat(value) * 100).toFixed(precision) + "%";
  } else if (type === "string") {
    return value;
  }
  return parseFloat(value)
    .toFixed(precision)
    .replace(/\d+/, function (n) {
      return n.replace(/(\d)(?=(\d{3})+$)/g, function ($1) {
        return $1 + ",";
      });
    });
};

const transferAmtFromCent = (value) => {
  if (value) {
    return parseInt(value) / 100;
  }
  return 0;
};

// Escape text for output in HTML
const escapeHtml = (text) => {
  return String(text)
    .replace(/&/g, "&amp;")
    .replace(/</g, "&lt;")
    .replace(/>/g, "&gt;")
    .replace(/"/g, "&quot;")
    .replace(/'/g, "&#039;")
    .replace(/\n/g, "<br/>");
};

const updateDisplayContent = (displayContent) => {
  const tagDisplay = document.getElementById("display");
  tagDisplay.innerHTML = "";
  if (Array.isArray(displayContent)) {
    displayContent.forEach(function (each) {
      const tagDiv = document.createElement("div");
      tagDiv.innerHTML = escapeHtml(each);
      tagDisplay.appendChild(tagDiv);
    });
  } else {
    const tagDiv = document.createElement("div");
    tagDiv.innerHTML = escapeHtml(displayContent);
    tagDisplay.appendChild(tagDiv);
  }
};

const displayPairStatus = (pairingStatus) => {
    if (pairingStatus == "Unpaired") {
        $("#rdAutoAddress").prop("disabled", false);
        $("#rdSignatureFlowOnEFTPOS").prop("disabled", false);
        $("#rdTest").prop("disabled", false);
        $("#tenants").prop("disabled", false);
        $("#serialNumber").prop("disabled", false);
        setAutoAddressEditable();
        $("#btn-pair").prop("disabled", false).show();
        $("#btn-unpair").prop("disabled", true).hide();
        $("#pairingStatus").text("UNPAIRED");
        $("#pairingStatus").attr("style", "color:black;");
    } else {
        $("#rdAutoAddress").prop("disabled", true);
        $("#rdSignatureFlowOnEFTPOS").prop("disabled", false);
        $("#rdTest").prop("disabled", true);
        $("#tenants").prop("disabled", true);
        $("#serialNumber").prop("disabled", true);
        $("#eftAddress").prop("disabled", true);
        $("#btn-pair").prop("disabled", true).hide();
        $("#btn-unpair").prop("disabled", false).show();
        if (pairingStatus == "PairedConnecting") {
            $("#pairingStatus").text("PAIRED BUT TRYING TO CONNECT");
            $("#pairingStatus").attr("style", "color:orange");
        } else {
            $("#pairingStatus").text("PAIRED AND CONNECTED");
            $("#pairingStatus").attr("style", "color:green");
        }
    }
};

const isWin = () => {
  var sUserAgent = navigator.userAgent.toLowerCase();
  if (sUserAgent.indexOf("windows") != -1) {
    return true;
  }
  return false;
};

function closeWindow() {
  if (isWin()) {
    var value = { name: "closePage" };
    window.postMessage(value);
  } else {
    window.closePage.postMessage("");
  }
}

function showGoBack() {
  if (isWin()) {
    var value = { name: "canGoBack", data: "true" };
    window.postMessage(value);
  } else {
    window.canGoBack.postMessage("true");
  }
}

function hideGoBack() {
  if (isWin()) {
    var value = { name: "canGoBack", data: "false" };
    window.postMessage(value);
  } else {
    window.canGoBack.postMessage("false");
  }
}


function formatDate(date) {
    date = new Date(date);
    return (
        date.getFullYear().toString() +
        (date.getMonth() + 1).toString().padStart(2, "0") +
        date.getDate().toString().padStart(2, "0")
    );
}

