function createHistoryTable(historyList) {
    var table =
        "<table class='table table-bordered'> \
                        <thead> \
                            <tr> \
                                <th>Order No.</th> \
                                <th>Type</th> \
                                <th>Amount</th> \
                                <th>Surcharge</th> \
                                <th>Tips</th> \
                                <th>Create Time</th> \
                                <th>Status</th> \
                                <th>Action</th> \
                            </tr> \
                        </thead> \
                        <tbody>";

    historyList.forEach(function (e) {
        table += "<tr>";
        table += "<td>" + e.OrderNo + "</td>";
        table += "<td>" + e.TransTypeDesc + "</td>";
        table += "<td>" + e.TransactionAmount + "</td>";
        table += "<td>" + e.Surcharge + "</td>";
        table += "<td>" + e.TipAmount + "</td>";
        table += "<td>" + e.CreateTime + "</td>";
        table += `<td class='${e.PayStatusDesc == "Success" ? "" : "bg-danger"}'>${e.PayStatusDesc}</td>`;
        if (e.HasCustomerReceipt) {
            table += `<td><button class=\"btn btn-primary\" onclick=\"showReprintDialog('${e.TransactionId}')\">Reprint</button>`
        } else {
            table += "<td>";
        }
        //table += `<button class=\"btn btn-light\" onclick=\"doGetTransaction('${e.TransactionId}')\">Retrive</button></td>`
        table += "</td>";
        table += "</tr>";
    });
    table += "</tbody></table>";
    return table;
}

const showReprintDialog = (transactionId) => {
    hideDialog();
    dialog = bootbox.dialog({
        title: "Reprint Receipt",
        message: `<p class="text-center"><h4> Please select the receipt you want to print.</h4></p>`,
        buttons: {
            printMerchant: {
                label: "Merchant Receipt",
                className: "btn btn-primary",
                callback: function () {
                    printReceipt(transactionId, 0);
                },
            },
            printCustomer: {
                label: "Customer Receipt",
                className: "btn btn-info",
                callback: function () {
                    printReceipt(transactionId, 1);
                },
            },
            all: {
                label: "Both Receipts",
                className: "btn btn-warning",
                callback: function () {
                    printReceipt(transactionId, 2);
                },
            },
            cancel: {
                label: "Cancel",
                className: "btn btn-danger",
                callback: function () { },
            },
        },
    });
};

const printReceipt = (transactionId, type) => {
    console.debug("maintenance.reprint request.transactionId,type:", transactionId, type);
    $.ajax({
        type: "POST",
        headers: {
            Accept: "application/json; charset=utf-8",
            ContentType: "application/json; charset=utf-8",
            MerchantId: zmerchantId,
            BranchId: zbranchId,
        },
        dataType: "json",
        contentType: "application/json;charset=UTF-8",
        url: `/api/eft/reprint/${transactionId}/${type}`,
        success: function (result) {
            console.debug("maintenance.reprint response.result:", result);
            if (result.Code == 1000) {
                hideDialog();
            } else {
                hideDialog();
                bootbox.dialog({
                    title: "",
                    message: `<p class="text-center"><h4> Reprint Receipt </h4></p>`,
                    buttons: {
                        ok: {
                            label: result.Data,
                            className: "btn btn-primary",
                            callback: function () { },
                        },
                    },
                });
            }
        },
        error: function (e) {
            console.debug("maintenance.reprint response error:", e.responseText);
            $("#history-msg").text(e.responseText);
        },
    });
};

const listHistory = () => {
    var date = $("#history-date").val();
    if (date == "") {
        return false;
    }
    date = formatDate(date);
    updateDisplayContent("Searching...");

    console.debug("maintenance.reprint request.params:machineID,date:", machineID, date);

    $.ajax({
        type: "GET",
        headers: {
            Accept: "application/json; charset=utf-8",
            ContentType: "application/json; charset=utf-8",
            MerchantId: zmerchantId,
            BranchId: zbranchId,
        },
        dataType: "json",
        contentType: "application/json;charset=UTF-8",
        url: `/api/eft/history/${machineID}/${date}`,
        success: function (result) {
            console.debug("maintenance.history response.result:", result);
            updateDisplayContent("");
            if (result.Code == 1000) {
                $("#history-table").html(createHistoryTable(result.Data));
            }
        },
        error: function (e) {
            console.debug("maintenance.history response.result:", e);
            updateDisplayContent(e.responseText);
        },
    });
};
