class Logger {
    // create logger
    constructor() {
        this.prefix = "worldline";

        this.storageKey = "timapi-logs";

        // Current log record lines
        this.linesCount = 0;

        // maximum number of logs to show
        this.maxLogCount = 1000;

        this.showFinest = true;

        this.debugout = new Debugout({
            useLocalStorage: true,
            useTimestamps: true,
            includeSessionMetadata: false,
            realTimeLoggingOn: false,
            indent: "",
            localStorageKey: this.storageKey,
        });
    }

    // activate logger attaching it to timapi
    activate() {
        const _this = this;
        onTimApiLog = function (message) {
            _this.info(message);
        };
        //TODO: what?
        onTimApiPublishLogRecord = function (record) {
            _this.publishLog(record);
        };
    }

    // clear logs
    clear() {
        this.linesCount = 0;
        this.debugout.clear();
        window.localStorage.removeItem(this.localStorageKey);
    }

    // add log message to the log list and also output it on the console
    info(...p) {
        console.log(...p);
        this.debugout.info(...p);
        this.linesCount++;
        if (this.linesCount === this.maxLogCount) {
            this.saveLogs();
            this.linesCount = 0;
        }
    }

    // publish log record. filters the log record and outputs it
    publishLog(record) {
        let message = String(record);
        if (
            this.showFinest ||
            record.matchesLevel(timapi.LogRecord.LogLevel.info)
        ) {
            timapi.log(message); // includes addFileLogs
        } else {
            this.addFileLogs(message);
        }
    }

    getLogs() {
        let logs = null;
        try {
            logs = window.localStorage.getItem(this.storageKey);
        } catch (error) {
            console.debug(">>> logger.getLogs error:", error);
        }
        return logs;
    }

    async saveLogs() {
        console.debug(">>> logger.saveLog start");
        const output = this.getLogs();
        if (output == null || output == "") {
            return;
        }
        const request = {};
        request.MachineID = machineID;
        request.LogKey = formatDate(new Date());
        request.LogText = output;

        try {
            const result = await $.ajax({
                type: "POST",
                headers: {
                    Accept: "application/json; charset=utf-8",
                    ContentType: "application/json; charset=utf-8",
                    MerchantId: merchantId,
                    BranchId: branchId,
                },
                url: `/api/eft/saveLog`,
                data: JSON.stringify(request),
                dataType: "json",
                contentType: "application/json;charset=UTF-8",
            });

            console.debug(">>> logger.saveLog response.result:", result);

            if (result.Code == "1000") {
                this.clear();
            } else {
                console.debug(">>> logger.saveLog response fail:", result.Message);
            }
        } catch (error) {
            console.debug(">>> logger.saveLog response error:", error);
        }
    }

    download(date) {
        const { protocol, host } = window.location;
        const url = `${protocol}//${host}/eftui/downloadlog?merchantId=${merchantId}&branchId=${branchId}&machineID=${machineID}&Seq=${Seq}&date=${formatDate(
            date
        )}`;
        //TODO: change bridge implement.
        // window.openBrowser.postMessage(url);
        window.hybridAPP.openBrowser(url);
    }
}
