const hideDialog = () => {
    $(".modal-backdrop").remove();
    $(".bootbox").remove();
    $("body").removeClass('modal-open');
};

const showDialog = (message) => {
  bootbox.alert(`<h4 class="text-center mb-0">` + message + `</h4>`);
};

const showUnpairDialog = (cb, isTrx = true, canRetry = true) => {

    if (canRetry) {
        bootbox.confirm({
            message: `<h4 class="text-center mb-0">Please contact operator to check the pairing status</h4>`,
            buttons: {
                confirm: {
                    label: "Retry",
                    className: "btn-success",
                },
                cancel: {
                    label: "Cancel",
                    className: "btn-light",
                },
            },
            callback: function (result) {
                if (result) {
                    cb()
                } else {
                    if (isTrx) {
                        doCancelTransaction();
                    } else {
                        hideDialog();
                    }
                }
            },
        });
    } else {
        bootbox.alert({
            message: `<h4 class="text-center mb-0">Please contact operator to check the pairing status</h4>`,
            callback: function () {
                if (isTrx) {
                    doCancelTransaction();
                } else {
                    hideDialog();
                }
            },
        });
    }

};

const showUnknownDialog = (message) => {
    bootbox.confirm({
        title: "Unable to verify transaction status",
        message: "Please confirm the transaction result on the EFTPOS terminal. <br />Does it show the transaction was successful?",
        buttons: {
            cancel: {
                label: "No",
                className: "btn btn-danger",
            },
            confirm: {
                label: "Yes",
                className: "btn-success",
            },
        },
        callback: function (result) {
            if (result) {
                cb()
            } else {
                doCancelTransaction();
            }
        },
    });
};

const showSignDialog = (message) => {
  bootbox.confirm({
    title: "EFTPOS - ID " + txn.TransactionId,
    message: `<h4 class="text-center mb-0">` + message + `</h4>`,
    buttons: {
      confirm: {
        label: "Accept",
        className: "btn-success",
      },
      cancel: {
        label: "Decline",
        className: "btn-danger",
      },
    },
    callback: function (result) {
        spi.AcceptSignature(result);
    },
  });
};
