
// Terminal listener updating the display
class UpdateDisplayListener extends timapi.DefaultTerminalListener {
	// Create listener
	constructor() {
		super();
	}

	// Terminal status changed
	terminalStatusChanged(terminal) {
		var status = terminal.getTerminalStatus();
		
		var tagDisplay = document.getElementById('display');
		tagDisplay.innerHTML = '';
		status.displayContent.forEach(function(each) {
			var tagDiv = document.createElement('div');
			tagDiv.innerHTML = escapeHtml(each);
			tagDisplay.appendChild(tagDiv);
		});
		
		document.getElementById('statusConnection').innerHTML = status.connectionStatus ?
			escapeHtml(humanReadableConstName(status.connectionStatus.name)) : '-';
		document.getElementById('statusManagement').innerHTML = status.managementStatus ?
			escapeHtml(humanReadableConstName(status.managementStatus.name)) : '-';
		document.getElementById('statusCardReader').innerHTML = status.cardReaderStatus ?
			escapeHtml(humanReadableConstName(status.cardReaderStatus.name)) : '-';
		document.getElementById('statusTransaction').innerHTML = status.transactionStatus ?
			escapeHtml(humanReadableConstName(status.transactionStatus.name)) : '-';
		document.getElementById('statusSleepMode').innerHTML = status.sleepModeStatus ?
			escapeHtml(humanReadableConstName(status.sleepModeStatus.name)) : '-';
		
		let flags = Array();
		if (status.swUpdateAvailable) {
			flags.push('swUpdateAvailable');
		}
		if (status.hasReceiptInformation) {
			flags.push('hasReceiptInformation');
		}
		document.getElementById('statusFlags').innerHTML = flags ? escapeHtml(flags.join(', ')) : '-';

		if (status.connectionStatus == timapi.constants.ConnectionStatus.disconnected) {
			ecr.connected = false;
		} else {
			ecr.connected = true;
		}
	}
}
